/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoLoad;
import com.quantumdata.ftp.CoProgress;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.ftp.JCoDirComboBox;
import com.quantumdata.ftp.JCoFileTable;
import com.quantumdata.ftp.LocalFile;
import com.quantumdata.ftpbrowser.FileEditor;
import com.quantumdata.ftpbrowser.FileListTransferHandler;
import com.quantumdata.ftpbrowser.FileProgressMonitor;
import com.quantumdata.ftpbrowser.FileTransferDialog;
import com.quantumdata.ftpbrowser.FtpBrowser;
import com.quantumdata.ftpbrowser.FtpOpenHandler;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBrowserPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private FtpBrowser m_browser;
    private JCoDirComboBox m_dirChoice;
    private JCoFileTable m_fileList;
    private JPopupMenu m_popupMenu;
    private JLabel m_statusLine;
    private boolean m_isGenerator;
    private boolean m_isUpdating = false;
    private boolean m_isSource = false;
    private Action m_openAction;
    private FtpOpenHandler m_openHandler = null;
    private Action m_backAction;
    private Action m_deleteAction;
    private Action m_transferAction;
    private Action m_mkDirAction;
    private Action m_renameAction;
    private Action m_executeAction;
    private Action m_screenCapAction;

    public FileBrowserPanel(FtpBrowser ftpBrowser, String string, boolean bl) {
        this.m_browser = ftpBrowser;
        this.m_isGenerator = bl;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 300));
        Font font = new Font("Dialog", 1, 14);
        Border border = BorderFactory.createEtchedBorder(0);
        this.setBorder(BorderFactory.createTitledBorder(border, string, 2, 1, font));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)new JLabel("Look in: "), "West");
        this.m_dirChoice = new JCoDirComboBox(bl);
        jPanel2.add((Component)this.m_dirChoice, "Center");
        this.m_dirChoice.setDirActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoFile coFile = FileBrowserPanel.this.m_dirChoice.getSelectedDir();
                FileBrowserPanel.this.dirSelected(coFile);
            }
        });
        ImageIcon imageIcon = QDUtil.createAppletImageIcon("images/FileBack.gif", FtpBrowser.class);
        this.m_backAction = new BackAction((Icon)imageIcon);
        this.m_backAction.setEnabled(false);
        JButton jButton = new JButton(this.m_backAction);
        jPanel2.add((Component)jButton, "East");
        jPanel.add((Component)jPanel2, "North");
        imageIcon = QDUtil.createAppletImageIcon("images/QDLogoSmall.gif", FtpBrowser.class);
        this.m_fileList = new JCoFileTable(imageIcon);
        this.m_fileList.setBackground(Color.white);
        this.m_fileList.setAlignmentY(0.0f);
        this.m_fileList.setOpaque(true);
        this.m_fileList.setBackground(Color.WHITE);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.m_fileList);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel3.add((Component)jScrollPane, "Center");
        FileListTransferHandler fileListTransferHandler = new FileListTransferHandler(this.m_fileList, this);
        this.m_fileList.setTransferHandler(fileListTransferHandler);
        this.m_fileList.setDragEnabled(true);
        jScrollPane.setTransferHandler(fileListTransferHandler);
        this.m_fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CoFile coFile = FileBrowserPanel.this.m_fileList.getSelectedFile();
                if (mouseEvent.getClickCount() > 1 && coFile != null) {
                    if (coFile.isDirectory()) {
                        FileBrowserPanel.this.dirSelected(coFile);
                    } else {
                        FileBrowserPanel.this.ExecuteItem(coFile);
                    }
                } else {
                    FileBrowserPanel.this.UpdateStatus();
                }
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.check(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.check(mouseEvent);
            }

            private void check(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    FileBrowserPanel.this.m_popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.m_fileList.addMouseListener(mouseAdapter);
        jScrollPane.addMouseListener(mouseAdapter);
        this.m_fileList.getSelectionModel().addListSelectionListener(this);
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_statusLine = new JLabel("  ");
        jPanel3.add((Component)this.m_statusLine, "West");
        this.add((Component)jPanel3, "South");
        JToolBar jToolBar = new JToolBar();
        this.m_popupMenu = new JPopupMenu();
        imageIcon = QDUtil.createAppletImageIcon("images/Open1.gif", FtpBrowser.class);
        this.m_openAction = new OpenAction((Icon)imageIcon);
        this.m_openAction.setEnabled(false);
        jButton = new JButton(this.m_openAction);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jToolBar.add(jButton);
        this.m_popupMenu.add(new JMenuItem(this.m_openAction));
        if (this.m_isGenerator) {
            imageIcon = QDUtil.createAppletImageIcon("images/Execute.gif", FtpBrowser.class);
            this.m_executeAction = new ExecuteAction((Icon)imageIcon);
            this.m_executeAction.setEnabled(false);
            jButton = new JButton(this.m_executeAction);
            jButton.setVerticalTextPosition(3);
            jButton.setHorizontalTextPosition(0);
            jToolBar.add(jButton);
            this.m_popupMenu.add(new JMenuItem(this.m_executeAction));
        }
        imageIcon = this.m_isGenerator ? QDUtil.createAppletImageIcon("images/Upload1.gif", FtpBrowser.class) : QDUtil.createAppletImageIcon("images/Download1.gif", FtpBrowser.class);
        this.m_transferAction = new TransferAction((Icon)imageIcon);
        this.m_transferAction.setEnabled(false);
        jButton = new JButton(this.m_transferAction);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jToolBar.add(jButton);
        this.m_popupMenu.add(new JMenuItem(this.m_transferAction));
        jToolBar.addSeparator();
        this.m_popupMenu.add(new JPopupMenu.Separator());
        imageIcon = QDUtil.createAppletImageIcon("images/NewDir.gif", FtpBrowser.class);
        this.m_mkDirAction = new MkDirAction((Icon)imageIcon);
        this.m_mkDirAction.setEnabled(false);
        jButton = new JButton(this.m_mkDirAction);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jToolBar.add(jButton);
        this.m_popupMenu.add(new JMenuItem(this.m_mkDirAction));
        imageIcon = QDUtil.createAppletImageIcon("images/Rename.gif", FtpBrowser.class);
        this.m_renameAction = new RenameAction((Icon)imageIcon);
        this.m_renameAction.setEnabled(false);
        jButton = new JButton(this.m_renameAction);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jToolBar.add(jButton);
        this.m_popupMenu.add(new JMenuItem(this.m_renameAction));
        jToolBar.addSeparator();
        this.m_popupMenu.add(new JPopupMenu.Separator());
        imageIcon = QDUtil.createAppletImageIcon("images/Delete1.gif", FtpBrowser.class);
        this.m_deleteAction = new DeleteAction((Icon)imageIcon);
        this.m_deleteAction.setEnabled(false);
        jButton = new JButton(this.m_deleteAction);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jToolBar.add(jButton);
        this.m_popupMenu.add(new JMenuItem(this.m_deleteAction));
        if (this.m_isGenerator) {
            jToolBar.addSeparator();
            this.m_popupMenu.add(new JPopupMenu.Separator());
            imageIcon = QDUtil.createAppletImageIcon("images/ScreenCap.gif", FtpBrowser.class);
            this.m_screenCapAction = new ScreenCapAction((Icon)imageIcon);
            this.m_screenCapAction.setEnabled(false);
            jButton = new JButton(this.m_screenCapAction);
            jButton.setVerticalTextPosition(3);
            jButton.setHorizontalTextPosition(0);
            jToolBar.add(jButton);
            this.m_popupMenu.add(new JMenuItem(this.m_screenCapAction));
        }
        jToolBar.addSeparator();
        this.add((Component)jToolBar, "First");
    }

    public void setOpenHandler(FtpOpenHandler ftpOpenHandler) {
        this.m_openHandler = ftpOpenHandler;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setEnabledStates();
    }

    private void setEnabledStates() {
        String string;
        CoFile coFile;
        this.UpdateStatus();
        if (this.m_isUpdating) {
            this.m_dirChoice.setEnabled(false);
            this.m_fileList.setEnabled(false);
            this.m_openAction.setEnabled(false);
            this.m_backAction.setEnabled(false);
            this.m_transferAction.setEnabled(false);
            this.m_deleteAction.setEnabled(false);
            this.m_mkDirAction.setEnabled(false);
            this.m_renameAction.setEnabled(false);
            if (this.m_isGenerator) {
                this.m_executeAction.setEnabled(false);
                this.m_screenCapAction.setEnabled(false);
            }
            return;
        }
        this.m_dirChoice.setEnabled(true);
        this.m_fileList.setEnabled(true);
        this.m_backAction.setEnabled(true);
        this.m_mkDirAction.setEnabled(true);
        int n = this.m_fileList.getSelectedRowCount();
        this.m_openAction.setEnabled(false);
        this.m_renameAction.setEnabled(false);
        if (this.m_isGenerator) {
            this.m_executeAction.setEnabled(false);
            this.m_screenCapAction.setEnabled(false);
        }
        if (n == 1) {
            coFile = this.m_fileList.getSelectedFile();
            if (!coFile.isDirectory()) {
                if (this.m_openHandler != null) {
                    this.m_openAction.setEnabled(this.m_openHandler.isOpenAllowed(coFile));
                } else {
                    this.m_openAction.setEnabled(true);
                }
                if (this.m_isGenerator) {
                    this.m_executeAction.setEnabled(true);
                }
            }
            this.m_renameAction.setEnabled(true);
        }
        this.m_transferAction.setEnabled(n > 0);
        this.m_deleteAction.setEnabled(n > 0);
        if (this.m_isGenerator && (coFile = this.m_dirChoice.getDir()) != null && !(string = coFile.getPathFragment(1).getName()).equalsIgnoreCase("ram20K")) {
            this.m_screenCapAction.setEnabled(true);
        }
    }

    public void dirSelected(CoFile coFile) {
        this.m_isUpdating = true;
        this.setEnabledStates();
        new Thread(new UpdateDirThread(coFile)).start();
    }

    public CoFile getSelectedDir() {
        return this.m_dirChoice.getSelectedDir();
    }

    public boolean getIsSource() {
        return this.m_isSource;
    }

    public void setIsSource(boolean bl) {
        this.m_isSource = bl;
    }

    public boolean transferFiles(List<Object> list) {
        Object object;
        Object object2;
        CoFile coFile = this.m_dirChoice.getSelectedDir();
        CoFile[] coFileArray = new CoFile[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CoFile coFile2;
            object2 = list.get(i);
            if (object2 instanceof FtpFile || object2 instanceof CoFile) {
                coFile2 = (CoFile)object2;
            } else if (object2 instanceof File) {
                object = (File)object2;
                coFile2 = new LocalFile(((File)object).getAbsolutePath());
            } else {
                System.out.println("*** Unrecognized Drop Object: " + object2.getClass().getName());
                return false;
            }
            coFileArray[i] = coFile2;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        object2 = new FileTransferDialog((Frame)jFrame, coFile, coFileArray);
        ((Dialog)object2).setVisible(true);
        if (!((FileTransferDialog)object2).isOk()) {
            return false;
        }
        this.m_dirChoice.setEnabled(false);
        this.m_fileList.setEnabled(false);
        int n = ((FileTransferDialog)object2).getFileCount() + ((FileTransferDialog)object2).getDirCount();
        object = new TransferThread(this, coFileArray, coFile, n);
        new Thread((Runnable)object).start();
        return false;
    }

    public void deleteFiles(CoFile[] coFileArray) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        FileTransferDialog fileTransferDialog = new FileTransferDialog((Frame)jFrame, null, coFileArray);
        fileTransferDialog.setVisible(true);
        if (!fileTransferDialog.isOk()) {
            return;
        }
        this.m_dirChoice.setEnabled(false);
        this.m_fileList.setEnabled(false);
        int n = fileTransferDialog.getFileCount() + fileTransferDialog.getDirCount();
        TransferThread transferThread = new TransferThread(this, coFileArray, n);
        new Thread(transferThread).start();
    }

    public void MakeFolder() {
        CoFile coFile = this.getSelectedDir();
        if (coFile == null) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        String string = JOptionPane.showInputDialog(jFrame, "Current Folder: " + coFile.getAbsolutePath(), "Enter a New Folder Name", 3);
        if (string == null) {
            return;
        }
        if (string instanceof String) {
            String string2 = string;
            CoFile coFile2 = coFile.newFileChild(string2);
            if (!coFile2.mkdir()) {
                JOptionPane.showMessageDialog(jFrame, "Unable to create the Folder: " + coFile2.getAbsolutePath(), "Error", 0);
            } else {
                this.dirSelected(coFile);
            }
        }
    }

    public void RenameItem() {
        CoFile coFile = this.m_fileList.getSelectedFile();
        if (coFile == null) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        Object object = JOptionPane.showInputDialog(jFrame, "Enter a new name:", "Rename...", 3, null, null, coFile.getName());
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            CoFile coFile2 = coFile.newFileRename(string);
            if (!coFile.renameTo(coFile2)) {
                String string2 = "Unable to rename\n" + coFile.getAbsolutePath() + "\nto\n" + coFile2.getAbsolutePath();
                JOptionPane.showMessageDialog(jFrame, string2, "Error", 0);
            } else {
                this.dirSelected(this.getSelectedDir());
            }
        }
    }

    public void ScreenCapture(CoFile coFile) {
        if (coFile == null) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        String string = JOptionPane.showInputDialog(jFrame, "Enter a file name:", "Capture Screen Bitmap", 3);
        if (string == null) {
            return;
        }
        if (string instanceof String) {
            String string2 = string;
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                String string3 = string2.substring(n);
                if (!string3.equalsIgnoreCase(".BMP")) {
                    string2 = string2.substring(0, n);
                    string2 = string2 + ".BMP";
                }
            } else {
                string2 = string2 + ".BMP";
            }
            this.m_isUpdating = true;
            this.setEnabledStates();
            new Thread(new CaptureThread(coFile, string2)).start();
        }
    }

    public void ExecuteItem(CoFile coFile) {
        String string;
        if (coFile == null) {
            return;
        }
        RemoteInstrument remoteInstrument = this.m_browser.getInstrument();
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd(string = "FILE:LOAD " + coFile.getAbsolutePath());
        if (instrumentResponse.isError()) {
            String string2 = "Failed to use: " + coFile.getAbsolutePath() + "\nError: " + instrumentResponse.getResponse();
            JOptionPane.showMessageDialog(this.m_browser, string2, "Error", 0);
        }
    }

    private void UpdateStatus() {
        CoFile[] coFileArray = this.m_fileList.getSelectedFiles();
        if (coFileArray.length == 0) {
            this.m_statusLine.setText("  ");
            return;
        }
        long l = 0L;
        for (int i = 0; i < coFileArray.length; ++i) {
            CoFile coFile = coFileArray[i];
            if (!coFile.isFile()) continue;
            l += coFile.length();
        }
        String string = coFileArray.length + " Object(s) Selected:  " + l + " Bytes";
        this.m_statusLine.setText(string);
    }

    private class TransferThread
    implements Runnable {
        private CoFile[] m_srcs;
        private CoFile m_dst;
        private int m_itemCount;
        private boolean m_deleteOperation = false;
        private Component m_parent;

        public TransferThread(Component component, CoFile[] coFileArray, CoFile coFile, int n) {
            this.m_srcs = coFileArray;
            this.m_dst = coFile;
            this.m_itemCount = n;
            this.m_parent = component;
        }

        public TransferThread(Component component, CoFile[] coFileArray, int n) {
            this.m_srcs = coFileArray;
            this.m_dst = null;
            this.m_itemCount = n;
            this.m_deleteOperation = true;
            this.m_parent = component;
        }

        public void run() {
            Component component;
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.m_parent);
            if (jFrame == null) {
                component = SwingUtilities.getAncestorOfClass(JApplet.class, this.m_parent);
                if (component == null) {
                    component = this.m_parent;
                }
            } else {
                component = jFrame;
            }
            Cursor cursor = component.getCursor();
            component.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_deleteOperation) {
                FileProgressMonitor fileProgressMonitor = new FileProgressMonitor((Frame)jFrame, "Deleting Files...", this.m_itemCount, true);
                fileProgressMonitor.setVisible(true);
                CoLoad.delete(this.m_srcs, fileProgressMonitor);
                FileBrowserPanel.this.dirSelected(FileBrowserPanel.this.getSelectedDir());
                fileProgressMonitor.setDone();
            } else {
                FileProgressMonitor fileProgressMonitor = new FileProgressMonitor((Frame)jFrame, "Copying Files...", this.m_itemCount, false);
                fileProgressMonitor.setVisible(true);
                CoLoad.copy(this.m_dst, this.m_srcs, (CoProgress)fileProgressMonitor);
                FileBrowserPanel.this.dirSelected(this.m_dst);
                fileProgressMonitor.setDone();
            }
            component.setCursor(cursor);
        }
    }

    private class CaptureThread
    implements Runnable {
        private String m_fileName;
        private CoFile m_dir;

        public CaptureThread(CoFile coFile, String string) {
            this.m_fileName = string;
            this.m_dir = coFile;
        }

        public void run() {
            FileBrowserPanel.this.m_browser.setCursor(Cursor.getPredefinedCursor(3));
            CoFile coFile = this.m_dir.newFileChild(this.m_fileName);
            RemoteInstrument remoteInstrument = FileBrowserPanel.this.m_browser.getInstrument();
            String string = "FILE:SCREENCAP " + coFile.getAbsolutePath();
            InstrumentResponse instrumentResponse = remoteInstrument.sendCmdAltChannel(string, 60000);
            FileBrowserPanel.this.dirSelected(this.m_dir);
            if (instrumentResponse.isError()) {
                String string2 = "Failed to finish capture to " + coFile.getAbsolutePath() + "\nError: " + instrumentResponse.getResponse();
                JOptionPane.showMessageDialog(FileBrowserPanel.this.m_browser, string2, "Error", 0);
            } else {
                FtpConnect ftpConnect = new FtpConnect();
                SocketConnection socketConnection = (SocketConnection)remoteInstrument.getConnection();
                ftpConnect.setHostName(socketConnection.getHostName());
                ftpConnect.setPassWord("");
                ftpConnect.setUserName("");
                Ftp ftp = new Ftp();
                IQDConsole iQDConsole = FileBrowserPanel.this.m_browser.getFtpServer().getContext().getConsole();
                ftp.getContext().setConsole(iQDConsole);
                try {
                    if (!ftp.connect(ftpConnect)) {
                        iQDConsole.println("*** Secondary FTP Connection Failed ***");
                    }
                }
                catch (Exception exception) {
                    iQDConsole.println("\nERROR" + exception.getMessage());
                }
                if (ftp.isConnected()) {
                    FtpFile ftpFile = new FtpFile(coFile.getAbsolutePath(), ftp);
                    new FileEditor(ftpFile);
                }
                FileBrowserPanel.this.m_isUpdating = false;
                FileBrowserPanel.this.setEnabledStates();
                FileBrowserPanel.this.m_browser.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class UpdateUIThread
    implements Runnable {
        CoFile m_dir;
        CoFile[] m_files;

        UpdateUIThread(CoFile coFile, CoFile[] coFileArray) {
            this.m_dir = coFile;
            this.m_files = coFileArray;
        }

        public void run() {
            FileBrowserPanel.this.m_dirChoice.setDir(this.m_dir);
            FileBrowserPanel.this.m_fileList.setFiles(this.m_files);
            FileBrowserPanel.this.m_isUpdating = false;
            FileBrowserPanel.this.setEnabledStates();
        }
    }

    class UpdateDirThread
    implements Runnable {
        CoFile m_dir;
        CoFile[] m_files = null;

        UpdateDirThread(CoFile coFile) {
            this.m_dir = coFile;
        }

        public void run() {
            FileBrowserPanel.this.m_browser.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_dir != null) {
                if (this.m_dir.isDirectory() || this.m_dir.isLink()) {
                    this.m_files = this.m_dir.listCoFiles();
                }
                if (this.m_files == null) {
                    this.m_dir = FileBrowserPanel.this.m_dirChoice.getDir();
                    this.m_files = FileBrowserPanel.this.m_fileList.getFiles();
                }
            }
            FileBrowserPanel.this.m_browser.setCursor(Cursor.getPredefinedCursor(0));
            SwingUtilities.invokeLater(new UpdateUIThread(this.m_dir, this.m_files));
        }
    }

    class TransferAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public TransferAction(Icon icon) {
            this.putValue("SmallIcon", icon);
            if (FileBrowserPanel.this.m_isGenerator) {
                this.putValue("ShortDescription", "Upload the selected files to a local drive");
                this.putValue("Name", "Upload");
            } else {
                this.putValue("ShortDescription", "Download the selected files to the Generator");
                this.putValue("Name", "Download");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoFile[] coFileArray = FileBrowserPanel.this.m_fileList.getSelectedFiles();
            if (coFileArray.length == 0) {
                return;
            }
            ArrayList<CoFile> arrayList = new ArrayList<CoFile>(coFileArray.length);
            for (int i = 0; i < coFileArray.length; ++i) {
                arrayList.add(i, coFileArray[i]);
            }
            FileBrowserPanel.this.m_browser.transferFiles(arrayList, FileBrowserPanel.this.m_isGenerator);
        }
    }

    class RenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RenameAction(Icon icon) {
            super("Rename");
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Rename the selected item");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileBrowserPanel.this.RenameItem();
        }
    }

    class MkDirAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MkDirAction(Icon icon) {
            super("New");
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Create a new folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileBrowserPanel.this.MakeFolder();
        }
    }

    class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction(Icon icon) {
            super("Delete");
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Delete the selected items");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoFile[] coFileArray = FileBrowserPanel.this.m_fileList.getSelectedFiles();
            if (coFileArray.length == 0) {
                return;
            }
            FileBrowserPanel.this.deleteFiles(coFileArray);
        }
    }

    class ScreenCapAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ScreenCapAction(Icon icon) {
            super("Snapshot");
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Capture the current Image to a BMP File");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoFile coFile = FileBrowserPanel.this.m_dirChoice.getDir();
            if (coFile != null) {
                FileBrowserPanel.this.ScreenCapture(coFile);
            }
        }
    }

    class BackAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public BackAction(Icon icon) {
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Move up one directory level");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            CoFile coFile = FileBrowserPanel.this.m_dirChoice.getDir();
            if (coFile != null && (n = coFile.getPathDepth()) > 0) {
                coFile = coFile.getPathFragment(n - 1);
                FileBrowserPanel.this.dirSelected(coFile);
            }
        }
    }

    class ExecuteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExecuteAction(Icon icon) {
            super("Use");
            this.putValue("ShortDescription", "Use the selected item in the Generator");
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoFile coFile = FileBrowserPanel.this.m_fileList.getSelectedFile();
            FileBrowserPanel.this.ExecuteItem(coFile);
        }
    }

    class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OpenAction(Icon icon) {
            super("Open");
            this.putValue("ShortDescription", "Open the selected file for editing");
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoFile coFile = FileBrowserPanel.this.m_fileList.getSelectedFile();
            if (coFile == null) {
                return;
            }
            if (FileBrowserPanel.this.m_openHandler != null) {
                switch (FileBrowserPanel.this.m_openHandler.openFile(coFile)) {
                    case -1: 
                    case 1: {
                        return;
                    }
                }
            }
            new FileEditor(coFile);
        }
    }
}

